# Football AI Agents (Flashscore + PostgreSQL + FastAPI + Telegram)

Проект запускает 3 сервиса:

1. **Core worker** (`core.worker`) — парсит Flashscore, обновляет БД, пересчитывает силу команд, пишет прогнозы
2. **API** (`api.app`) — FastAPI эндпоинты (health, matches, predictions, insights)
3. **Telegram bot** (`bot.bot`) — уведомления и команды

## 1) Что куда вставить (обязательно)

Создай файл `.env` в корне проекта (там же где `requirements.txt`).

Пример:

```
DATABASE_URL=postgresql+asyncpg://football:football_pass@127.0.0.1:5432/football_ai
TELEGRAM_BOT_TOKEN=YOUR_TELEGRAM_BOT_TOKEN
TELEGRAM_ADMIN_CHAT_ID=8322510790

# Несколько лиг через |
FLASHSCORE_COMPETITION_URLS=https://www.flashscore.com/football/england/premier-league/|https://www.flashscore.com/football/spain/laliga/

# ... (опционально)
OPENAI_API_KEY=YOUR_OPENAI_API_KEY
OPENAI_MODEL=gpt-4o-mini

PARSER_USE_PLAYWRIGHT=true
PARSER_HEADLESS=true
INCLUDE_RESULTS_PAGES=true

REFRESH_UPCOMING_EVERY_S=120
REFRESH_LIVE_EVERY_S=45
LOOP_TICK_S=4
```

## 2) Установка зависимостей

```
python3 -m venv venv
source venv/bin/activate
pip install -U pip
pip install -r requirements.txt
python -m playwright install --with-deps chromium
```

Если Playwright ругается на `libatk-1.0.so.0` (как у тебя было) — значит не хватило системных библиотек. Команда выше (`--with-deps`) обычно ставит их сама.

## 3) Инициализация базы

```
source venv/bin/activate
python -m scripts.init_db
```

## 4) Запуск вручную (диагностика)

```
source venv/bin/activate
python -m core.worker
```

Во втором окне:

```
source venv/bin/activate
uvicorn api.app:app --host 0.0.0.0 --port 8000
curl http://127.0.0.1:8000/health
```

## 5) systemd (прод)

Шаблоны лежат в `deploy/systemd/`. Отредактируй пути под свой сервер (или оставь как есть, если проект лежит в `/var/www/www-root/data/www/77.83.87.30`).

```
cp deploy/systemd/*.service /etc/systemd/system/
systemctl daemon-reload
systemctl enable --now football-core football-api football-bot
systemctl status football-core football-api football-bot
```

## 6) Nginx + домен

Шаблон: `deploy/nginx/football_api.conf`.

1) Поставь свой `server_name` (домен)
2) Скопируй в `/etc/nginx/sites-available/football_api.conf`
3) Включи:

```
ln -s /etc/nginx/sites-available/football_api.conf /etc/nginx/sites-enabled/football_api.conf
nginx -t && systemctl reload nginx
```

## Почему team_stats может быть пустая?

`team_stats` считается **только по finished матчам**. Если в БД всего 5–10 finished игр, а по каждой команде 1–2 — статистика не посчитается (это защита от мусора).

Решение:
* включён `INCLUDE_RESULTS_PAGES=true` — воркер автоматически тянет `/results/` страницы лиг, чтобы накопить finished матчи
* дай воркеру поработать 5–15 минут
