# Куда что вставлять

## 1) PostgreSQL
Файл: `.env`
- DATABASE_URL=postgresql+asyncpg://USER:PASS@HOST:PORT/DB

По умолчанию в .env.example:
`postgresql+asyncpg://football:football_pass@127.0.0.1:5432/football_ai`

SQL создания пользователя/БД: `deploy/postgres.sql`

## 2) Telegram
Файл: `.env`
- TELEGRAM_BOT_TOKEN=... (токен от BotFather)
- TELEGRAM_ADMIN_CHAT_ID=... (твой chat_id для уведомлений)

Где используется:
- `bot/bot.py` читает settings.TELEGRAM_BOT_TOKEN и settings.TELEGRAM_ADMIN_CHAT_ID.

## 3) OpenAI
Файл: `.env`
- OPENAI_API_KEY=...
- OPENAI_MODEL=gpt-4o-mini (или другая)

Где используется:
- `api/openai_client.py`

Если OPENAI_API_KEY пустой — `/insights/{match_id}` вернёт null.

## 4) Лиги (несколько)
Файл: `.env`
- FLASHSCORE_COMPETITION_URLS=URL1|URL2|URL3

Где используется:
- `core/worker.py` -> settings.competition_urls()

## 5) Playwright (JS pages)
Файл: `.env`
- PARSER_USE_PLAYWRIGHT=true/false
- PARSER_HEADLESS=true/false

Где используется:
- `agents/parser_agent.py`

Установка браузера:
`python -m playwright install chromium`
