# Football AI Agents (Prod)

Services:
- Core Worker: parses matches, updates live scores, generates predictions, computes metrics.
- API (FastAPI): read-only access to matches/predictions/metrics/insights.
- Telegram Bot (aiogram): commands + live notifications.

## Quick start (Ubuntu)
1) Install system deps:
   - Python 3.10+ (3.9+ ok)
   - PostgreSQL 14+
   - Playwright Chromium (optional but recommended for JS pages)

2) Create venv + deps:
   python3 -m venv venv
   source venv/bin/activate
   pip install -r requirements.txt
   python -m playwright install chromium

3) Configure:
   cp .env.example .env
   nano .env

4) Init DB:
   python -m scripts.init_db

5) Run locally:
   python -m core.worker
   uvicorn api.app:app --host 0.0.0.0 --port 8000
   python -m bot.bot

## systemd
See ./deploy/systemd/*.service
