from __future__ import annotations
from database.manager import DatabaseManager

class AnalyzerAgent:
    def __init__(self, db: DatabaseManager) -> None:
        self.db = db

    async def team_form(self, team: str, n: int = 5) -> dict:
        rows = await self.db.last_matches_for_team(team, limit=n)
        points = gf = ga = 0
        for m in rows:
            if m.home_team == team:
                gf += m.home_score or 0
                ga += m.away_score or 0
                if (m.home_score or 0) > (m.away_score or 0): points += 3
                elif (m.home_score or 0) == (m.away_score or 0): points += 1
            else:
                gf += m.away_score or 0
                ga += m.home_score or 0
                if (m.away_score or 0) > (m.home_score or 0): points += 3
                elif (m.away_score or 0) == (m.home_score or 0): points += 1
        return {"team": team, "n": len(rows), "points": points, "gf": gf, "ga": ga}

    async def h2h(self, a: str, b: str, limit: int = 8) -> list[dict]:
        rows = await self.db.head_to_head(a, b, limit=limit)
        return [{"kickoff_ts": r.kickoff_ts, "home": r.home_team, "away": r.away_team, "hs": r.home_score, "as": r.away_score} for r in rows]
