from __future__ import annotations
import json
from typing import Any, Optional
from openai import OpenAI
from config import settings

_client: Optional[OpenAI] = None

def client() -> Optional[OpenAI]:
    global _client
    if not settings.OPENAI_API_KEY:
        return None
    if _client is None:
        _client = OpenAI(api_key=settings.OPENAI_API_KEY)
    return _client

def build_prompt(ctx: dict[str, Any]) -> str:
    return (
        "Ты — футбольный аналитик. Дай инсайты по матчу на основе данных. "
        "Верни строго JSON вида: "
        "{"summary":string,"key_factors":string[],"risks":string[],"suggested_angles":string[],"data_gaps":string[]}\n"
        "Данные: " + json.dumps(ctx, ensure_ascii=False)
    )

def get_insight(ctx: dict[str, Any]) -> Optional[dict[str, Any]]:
    c = client()
    if not c:
        return None
    r = c.responses.create(
        model=settings.OPENAI_MODEL,
        input=build_prompt(ctx),
        max_output_tokens=700
    )
    text = getattr(r, "output_text", "") or ""
    # parse json best-effort
    try:
        return json.loads(text)
    except Exception:
        s = text.find("{"); e = text.rfind("}")
        if s!=-1 and e!=-1 and e>s:
            try:
                return json.loads(text[s:e+1])
            except Exception:
                return {"summary": text[:1200], "key_factors": [], "risks": ["unstructured_output"], "suggested_angles": [], "data_gaps": []}
        return {"summary": text[:1200], "key_factors": [], "risks": ["unstructured_output"], "suggested_angles": [], "data_gaps": []}
