from __future__ import annotations
import os
from sqlalchemy.ext.asyncio import create_async_engine, AsyncSession
from sqlalchemy.orm import sessionmaker
from config import settings
from database.models import Base

engine = create_async_engine(settings.DATABASE_URL, echo=False, future=True, pool_pre_ping=True)
SessionLocal = sessionmaker(engine, class_=AsyncSession, expire_on_commit=False)

async def init_db() -> None:
    os.makedirs("data", exist_ok=True)  # harmless for postgres; useful for logs/cache if needed
    async with engine.begin() as conn:
        await conn.run_sync(Base.metadata.create_all)
