from __future__ import annotations
import time
from typing import Any

class TTLCache:
    def __init__(self, ttl_s: int, max_size: int = 4096) -> None:
        self.ttl_s = ttl_s
        self.max_size = max_size
        self._d: dict[str, tuple[float, Any]] = {}

    def get(self, k: str) -> Any | None:
        v = self._d.get(k)
        if not v:
            return None
        ts, val = v
        if time.time() - ts > self.ttl_s:
            self._d.pop(k, None)
            return None
        return val

    def set(self, k: str, v: Any) -> None:
        if len(self._d) >= self.max_size:
            oldest = min(self._d.keys(), key=lambda x: self._d[x][0])
            self._d.pop(oldest, None)
        self._d[k] = (time.time(), v)
