from __future__ import annotations
import asyncio, time

class AsyncRateLimiter:
    def __init__(self, min_delay_s: float) -> None:
        self.min_delay_s = max(0.05, float(min_delay_s))
        self._lock = asyncio.Lock()
        self._next = 0.0

    async def wait(self) -> None:
        async with self._lock:
            now = time.time()
            if now < self._next:
                await asyncio.sleep(self._next - now)
            self._next = max(now, self._next) + self.min_delay_s
